# The vmms::db::mysql class implements mysql backend for vmms
#
# This class can be used to create tables, users and grant
# privilege for a mysql vmms database.
#
# == Parameters
#
# [*password*]
#   (Required) Password to connect to the database.
#
# [*dbname*]
#   (Optional) Name of the database.
#   Defaults to 'vmms'.
#
# [*user*]
#   (Optional) User to connect to the database.
#   Defaults to 'vmms'.
#
# [*host*]
#   (Optional) The default source host user is allowed to connect from.
#   Defaults to '127.0.0.1'
#
# [*allowed_hosts*]
#   (Optional) Other hosts the user is allowed to connect from.
#   Defaults to 'undef'.
#
# [*charset*]
#   (Optional) The database charset.
#   Defaults to 'utf8'
#
# [*collate*]
#   (Optional) The database collate.
#   Only used with mysql modules >= 2.2.
#   Defaults to 'utf8_general_ci'
#
class vmms::db::mysql(
  String[1] $password,
  $dbname        = 'vmms',
  $user          = 'vmms',
  $host          = '127.0.0.1',
  $charset       = 'utf8',
  $collate       = 'utf8_general_ci',
  $allowed_hosts = undef
) {

  include vmms::deps

  ::openstacklib::db::mysql { 'vmms':
    user          => $user,
    password      => $password,
    dbname        => $dbname,
    host          => $host,
    charset       => $charset,
    collate       => $collate,
    allowed_hosts => $allowed_hosts,
  }

  Anchor['vmms::db::begin']
  ~> Class['vmms::db::mysql']
  ~> Anchor['vmms::db::end']
}
