# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class GovernanceRuleConditionOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The governance rule Condition's Operator, for example Equals for severity or In for list of
    assessments, see examples.
    """

    EQUALS = "Equals"
    """Checks that the string value of the data defined in Property equals the given value - exact fit"""
    IN_ENUM = "In"
    """Checks that the string value of the data defined in Property equals any of the given values
    (exact fit)"""


class GovernanceRuleOwnerSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The owner type for the governance rule owner source."""

    BY_TAG = "ByTag"
    """The rule source type defined using resource tag"""
    MANUALLY = "Manually"
    """The rule source type defined manually"""


class GovernanceRuleSourceResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The governance rule source, what the rule affects, e.g. Assessments."""

    ASSESSMENTS = "Assessments"
    """The source of the governance rule is assessments"""


class GovernanceRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type of the governance rule, defines the source of the rule e.g. Integrated."""

    INTEGRATED = "Integrated"
    """The source of the rule type definition is integrated"""
    SERVICE_NOW = "ServiceNow"
    """The source of the rule type definition is ServiceNow"""


class OperationResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the long run operation result of governance rule."""

    SUCCEEDED = "Succeeded"
    """The operation succeeded"""
    FAILED = "Failed"
    """The operation failed"""
    CANCELED = "Canceled"
    """The operation canceled"""
