% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{HierarchicalParam-class}
\alias{HierarchicalParam-class}
\alias{.defaultScalarArguments,HierarchicalParam-method}
\alias{show,HierarchicalParam-method}
\title{The HierarchicalParam class}
\description{
The HierarchicalParam is a virtual subclass of the \linkS4class{BlusterParam} class.
It causes \code{\link{clusterRows}} to dispatch to clustering algorithms that produce a dissimilarity matrix and a dendrogram.
}
\section{Available slots}{

The virtual class provides \code{metric}, the choice of distance metric.
This is conventionally passed to \code{\link{dist}} and defaults to a Euclidean distance in most subclasses.
The distance function can be changed with the parameter \code{dist.fun}.

It also provides a number of slots to manage the final tree cut:
\itemize{
\item \code{cut.fun}, a function that takes a \link{hclust} object as its first argument and returns a vector of cluster assignments.
If \code{NULL}, the choice of function is determined from \code{cut.dynamic}.
\item \code{cut.dynamic}, a logical scalar indicating whether a dynamic tree cut should be performed by \code{\link[dynamicTreeCut]{cutreeDynamic}}.
Otherwise \code{\link{cutree}} is used.
Ignored if \code{cut.fun} is not \code{NULL}.
\item \code{cut.params}, further arguments to pass to the tree cut function specified by the previous arguments.
}
}

\section{Return value}{

The contract is that, when \code{full=TRUE}, the \code{objects} field of the \code{\link{clusterRows}} return value will always contain at least the following elements:
\itemize{
\item \code{dist}, a \link{dist} object containing a dissimilarity matrix, usually a distance matrix.
\item \code{hclust}, a \link{hclust} object containing a dendrogram.
}
}

\seealso{
\linkS4class{HclustParam}, for the archetypal example of a concrete subclass.
}
