% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSample.R
\name{makeSequenceTable}
\alias{makeSequenceTable}
\title{Construct a sample-by-sequence observation matrix.}
\usage{
makeSequenceTable(samples, orderBy = "abundance")
}
\arguments{
\item{samples}{(Required). A \code{list} of the samples to include in the sequence table. 
Samples can be provided in any format that can be processed by \code{\link{getUniques}}.
Sample names are propagated to the rownames of the sequence table.}

\item{orderBy}{(Optional). \code{character(1)}. Default "abundance".
Specifies how the sequences (columns) of the returned table should be ordered (decreasing).
Valid values: "abundance", "nsamples", NULL.}
}
\value{
Named integer matrix.
A row for each sample, and a column for each unique sequence across all the samples.
Note that the columns are named by the sequence which can make display a little unwieldy.
}
\description{
This function constructs a sequence table (analogous to an OTU table) from
the provided list of samples.
}
\examples{
derep1 <- derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
derep2 <- derepFastq(system.file("extdata", "sam2F.fastq.gz", package="dada2"))
dada1 <- dada(derep1, tperr1)
dada2 <- dada(derep2, tperr1)
seqtab <- makeSequenceTable(list(sample1=dada1, sample2=dada2))

}
\seealso{
\code{\link{dada}}, \code{\link{getUniques}}
}
