% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5A.R
\name{H5Acreate}
\alias{H5Acreate}
\title{Create an attribute for an HDF5 object}
\usage{
H5Acreate(h5obj, name, dtype_id, h5space)
}
\arguments{
\item{h5obj}{An object of class \linkS4class{H5IdComponent} representing a H5 object
identifier (file, group, or dataset). See \code{\link[=H5Fcreate]{H5Fcreate()}}, \code{\link[=H5Fopen]{H5Fopen()}},
\code{\link[=H5Gcreate]{H5Gcreate()}}, \code{\link[=H5Gopen]{H5Gopen()}}, \code{\link[=H5Dcreate]{H5Dcreate()}}, or \code{\link[=H5Dopen]{H5Dopen()}} to create an object of this kind.}

\item{name}{The name of the attribute (character).}

\item{dtype_id}{A character name of a datatype. See \code{h5const("H5T")} for
possible datatypes. Can also be an integer representing an HDF5 datatype.
Only simple datatypes are allowed for atttributes.}

\item{h5space}{An object of class \linkS4class{H5IdComponent} representing a H5
dataspace. See \code{\link[=H5Dget_space]{H5Dget_space()}}, \code{\link[=H5Screate_simple]{H5Screate_simple()}}, \code{\link[=H5Screate]{H5Screate()}} to create an object
of this kind.}
}
\value{
An object of class \linkS4class{H5IdComponent} representing a H5 attribute identifier.
}
\description{
Creates an attribute, \code{name}, which is attached to the object specified
by the identifier \code{h5obj}. The attribute name must be unique for the object.
}
