% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGroupedHeatmap.R
\name{plotGroupedHeatmap}
\alias{plotGroupedHeatmap}
\title{Plot heatmap of group-level expression averages}
\usage{
plotGroupedHeatmap(
  object,
  features,
  group,
  block = NULL,
  columns = NULL,
  exprs_values = "logcounts",
  center = FALSE,
  scale = FALSE,
  zlim = NULL,
  colour = color,
  swap_rownames = NULL,
  color = NULL,
  assay.type = exprs_values,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{SingleCellExperiment} object.}

\item{features}{A character (or factor) vector of row names, a logical vector, or integer vector of indices specifying rows of \code{object} to visualize. When using character or integer vectors, the ordering specified by the user is retained. When using factor vectors, ordering is controlled by the factor levels.}

\item{group}{String specifying the field of \code{\link{colData}(object)} containing the grouping factor, e.g., cell types or clusters.
Alternatively, any value that can be used in the \code{by} argument to \code{\link{retrieveCellInfo}}.}

\item{block}{String specifying the field of \code{\link{colData}(object)} containing a blocking factor (e.g., batch of origin).
Alternatively, any value that can be used in the \code{by} argument to \code{\link{retrieveCellInfo}}.}

\item{columns}{A vector specifying the subset of columns in \code{object} to use when computing averages.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{center}{A logical scalar indicating whether each feature should have its mean expression 
(specifically, the mean of averages across all groups) centered at zero prior to plotting.}

\item{scale}{A logical scalar specifying whether each row should have its
average expression values scaled to unit variance prior to plotting.}

\item{zlim}{A numeric vector of length 2, specifying the upper and lower bounds for colour mapping of expression values.
Values outside this range are set to the most extreme colour.
If \code{NULL}, it defaults to the range of the expression matrix.
If \code{center=TRUE}, this defaults to the range of the centered expression matrix, made symmetric around zero.}

\item{colour}{A vector of colours specifying the palette to use for increasing expression. 
This defaults to \link[viridis]{viridis} if \code{center=FALSE}, and the the \code{"RdYlBu"}
colour palette from \code{\link[RColorBrewer]{brewer.pal}} otherwise.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}

\item{color}{Alias to \code{colour}.}

\item{assay.type}{A string or integer scalar indicating which assay of \code{object} should be used as expression values.}

\item{...}{Additional arguments to pass to \code{\link[pheatmap]{pheatmap}}.}
}
\value{
A heatmap is produced on the current graphics device. 
The output of \code{\link[pheatmap]{pheatmap}} is invisibly returned.
}
\description{
Create a heatmap of average expression values for each group of cells and specified features in a SingleCellExperiment object.
}
\details{
This function shows the average expression values for each group of cells on a heatmap, as defined using the \code{group} factor.
A per-group visualization can be preferable to a per-cell visualization when dealing with large number of cells or groups with different size.
If \code{block} is also specified, the block effect is regressed out of the averages with \code{\link{correctGroupSummary}} prior to visualization.

Setting \code{center=TRUE} is useful for examining log-fold changes of each group's expression profile from the average across all groups.
This avoids issues with the entire row appearing a certain colour because the gene is highly/lowly expressed across all cells.

Setting \code{zlim} preserves the dynamic range of colours in the presence of outliers. 
Otherwise, the plot may be dominated by a few genes, which will \dQuote{flatten} the observed colours for the rest of the heatmap.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
example_sce$Group <- paste0(example_sce$Treatment, "+", example_sce$Mutation_Status)

plotGroupedHeatmap(example_sce, features=rownames(example_sce)[1:10],
    group="Group")

plotGroupedHeatmap(example_sce, features=rownames(example_sce)[1:10],
    group="Group", center=TRUE)

plotGroupedHeatmap(example_sce, features=rownames(example_sce)[1:10],
    group="Group", block="Cell_Cycle", center=TRUE)

}
\seealso{
\code{\link[pheatmap]{pheatmap}}, for the underlying function.

\code{\link{plotHeatmap}}, for a per-cell heatmap.
}
\author{
Aaron Lun
}
