"RV.rtest" <- function (df1, df2, nrepet = 99, ...) {
    if (!is.data.frame(df1)) 
        stop("data.frame expected")
    if (!is.data.frame(df2)) 
        stop("data.frame expected")
    l1 <- nrow(df1)
    if (nrow(df2) != l1) 
        stop("Row numbers are different")
    if (any(row.names(df2) != row.names(df1))) 
        stop("row names are different")
    X <- scale(df1, scale = FALSE)
    Y <- scale(df2, scale = FALSE)
    X <- X/(sum(svd(X)$d^4)^0.25)
    Y <- Y/(sum(svd(Y)$d^4)^0.25)
    X <- as.matrix(X)
    Y <- as.matrix(Y)
    obs <- sum(svd(t(X) %*% Y)$d^2)
    if (nrepet == 0) 
        return(obs)
    perm <- matrix(0, nrow = nrepet, ncol = 1)
    perm <- apply(perm, 1, function(x) sum(svd(t(X) %*% Y[sample(l1), 
        ])$d^2))
    w <- as.randtest(obs = obs, sim = perm, call = match.call(), ...)
    return(w)
}
