% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{post.var}
\alias{post.var}
\alias{post.pr2}
\alias{deviance.bma}
\alias{deviance.zlm}
\title{Posterior Variance and Deviance}
\usage{
post.var(object, exact = FALSE, ...)
}
\arguments{
\item{object}{A \code{bma} object (as produced by \code{\link{bms}}) or a
\code{\link{zlm}} object.}

\item{exact}{When \code{exact=FALSE}, then \code{deviance} will be based on
MCMC frequencies, if \code{exact=TRUE} then it will be based on\cr
analytical posterior model probabilities - cf. argument \code{exact} in
\code{\link{coef.bma}}.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Returns posterior residual variance, deviance, or pseudo R-squared,
according to the chosen prior structure
}
\details{
\code{post.var}: Posterior residual variance as according to the prior
definitions contained in \code{object} \cr \code{post.pr2}: A
pseudo-R-squared corresponding to unity minus posterior variance over
dependent variance. \cr \code{deviance.bma}: returns the
\code{\link{deviance}} of a \code{bma} model as returned from
\code{\link{bms}}. \cr \code{deviance.zlm}: returns the
\code{\link{deviance}} of a \code{\link{zlm}} model.
}
\examples{

 data(datafls)
  
 mm=bms(datafls[,1:10])
 deviance(mm)/nrow(datafls) # is equivalent to
 post.var(mm)
 
 post.pr2(mm) # is equivalent to
 1 - post.var(mm) / ( var(datafls[,1])*(1-1/nrow(datafls)) )
 
}
\seealso{
\code{\link{bms}} for creating \code{bma} objects and priors,
\code{\link{zlm}} object.

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
