% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{do_call}
\alias{do_call}
\title{Execute a Function Call}
\usage{
do_call(what, args, pkg = NULL, envir = parent.frame())
}
\arguments{
\item{what}{Either a function or a non-empty character string naming the
function to be called.}

\item{args}{A list of arguments to the function call. The names attribute of
\code{args} gives the argument names.}

\item{pkg}{Optional name of the package in which to search for the
function if \code{what} is a character string.}

\item{envir}{An environment within which to evaluate the call.}
}
\value{
The result of the (evaluated) function call.
}
\description{
Execute a function call similar to \code{\link{do.call}}, but without
deparsing function arguments. For large number of arguments (i.e., more
than a few thousand) this function currently is somewhat inefficient
and should be used with care in this case.
}
\keyword{internal}
