% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotQQunif}
\alias{plotQQunif}
\title{Quantile-quantile plot for a uniform distribution}
\usage{
plotQQunif(simulationOutput, testUniformity = TRUE, testOutliers = TRUE,
  testDispersion = TRUE, ...)
}
\arguments{
\item{simulationOutput}{A DHARMa simulation output (class DHARMa).}

\item{testUniformity}{If T, the function \link{testUniformity} will be called and the result will be added to the plot.}

\item{testOutliers}{If T, the function \link{testOutliers} will be called and the result will be added to the plot.}

\item{testDispersion}{If T, the function \link{testDispersion} will be called and the result will be added to the plot.}

\item{...}{Arguments to be passed on to \link[gap:qqunif]{gap::qqunif}.}
}
\description{
The function produces a uniform quantile-quantile plot from a DHARMa output. Optionally, tests for uniformity, outliers and dispersion can be added.
}
\details{
The function calls qqunif() from the R package gap to create a quantile-quantile plot for a uniform distribution, and overlays tests for particular distributional problems as specified.
When tests are displayed, significant p-values are highlighted in the color red by default. This can be changed by setting \code{options(DHARMaSignalColor = "red")} to a different color. See \code{getOption("DHARMaSignalColor")} for the current setting.
}
\examples{
testData = createData(sampleSize = 200, family = poisson(), 
                      randomEffectVariance = 1, numGroups = 10)
fittedModel <- glm(observedResponse ~ Environment1, 
                   family = "poisson", data = testData)
simulationOutput <- simulateResiduals(fittedModel = fittedModel)

######### main plotting function #############

# for all functions, quantreg = T will be more
# informative, but slower

plot(simulationOutput, quantreg = FALSE)

#############  Distribution  ######################

plotQQunif(simulationOutput = simulationOutput, 
           testDispersion = FALSE,
           testUniformity = FALSE,
           testOutliers = FALSE)

hist(simulationOutput )

#############  residual plots  ###############

# rank transformation, using a simulationOutput
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE)

# smooth scatter plot - usually used for large datasets, default for n > 10000
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE, smoothScatter = TRUE)

# residual vs predictors, using explicit values for pred, residual 
plotResiduals(simulationOutput, form = testData$Environment1, 
              quantreg = FALSE)

# if pred is a factor, or if asFactor = TRUE, will produce a boxplot
plotResiduals(simulationOutput, form = testData$group)

# to diagnose overdispersion and heteroskedasticity it can be useful to 
# display residuals as absolute deviation from the expected mean 0.5
plotResiduals(simulationOutput, absoluteDeviation = TRUE, quantreg = FALSE)

# All these options can also be provided to the main plotting function

# If you want to plot summaries per group, use
simulationOutput = recalculateResiduals(simulationOutput, group = testData$group)
plot(simulationOutput, quantreg = FALSE) 
# we see one residual point per RE


}
\seealso{
\link{plotSimulatedResiduals}, \link{plotResiduals}
}
