% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_edge.R
\name{delete_edge}
\alias{delete_edge}
\title{Delete an edge from an existing graph object}
\usage{
delete_edge(graph, from = NULL, to = NULL, id = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{from}{a node ID from which the edge to be removed is outgoing. If an
edge ID is provided to \code{id}, then this argument is ignored. There is
the option to use a node \code{label} value here (and this must
correspondingly also be done for the \code{to} argument) for defining node
connections. Note that this is only possible if all nodes have distinct
\code{label} values set and none exist as an empty string.}

\item{to}{a node ID to which the edge to be removed is incoming. If an edge
ID is provided to \code{id}, then this argument is ignored. There is the
option to use a node \code{label} value here (and this must correspondingly
also be for the \code{from} argument) for defining node connections. Note
that this is only possible if all nodes have distinct \code{label} values
set and none exist as an empty string.}

\item{id}{an edge ID of the edge to be removed.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, delete an existing edge by
specifying either: (1) a pair of node IDs corresponding to the edge (keeping
into consideration the direction of the edge in a directed graph), or (2) an
edge ID.
}
\examples{
# Create a graph with 2 nodes
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 2)

# Add an edge
graph <-
  graph \%>\%
  add_edge(
    from = 1,
    to = 2)

# Delete the edge
graph <-
  graph \%>\%
  delete_edge(
    from = 1,
    to = 2)

# Get the count of edges in the graph
graph \%>\% count_edges()

# Create an undirected graph with
# 2 nodes and an edge
graph_undirected <-
  create_graph(directed = FALSE) \%>\%
  add_n_nodes(n = 2) \%>\%
  add_edge(
    from = 1,
    to = 2)

# Delete the edge; the order of node ID
# values provided in `from` and `to`
# don't matter for the undirected case
graph_undirected \%>\%
  delete_edge(
    from = 2,
    to = 1) \%>\%
  count_edges()

# The undirected graph has a single
# edge with ID `1`; it can be
# deleted by specifying `id`
graph_undirected \%>\%
  delete_edge(id = 1) \%>\%
  count_edges()

# Create a directed graph with 2
# labeled nodes and an edge
graph_labeled_nodes <-
  create_graph() \%>\%
  add_n_nodes(
    n = 2,
    label = c("one", "two")) \%>\%
  add_edge(
    from = "one",
    to = "two")

# Delete the edge using the node
# labels in `from` and `to`; this
# is analogous to creating the
# edge using node labels
graph_labeled_nodes \%>\%
  delete_edge(
    from = "one",
    to = "two") \%>\%
  count_edges()

}
\seealso{
Other edge creation and removal: 
\code{\link{add_edge}()},
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs}()},
\code{\link{set_edge_attrs_ws}()}
}
\concept{edge creation and removal}
