% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\docType{methods}
\name{maximize_correlation,dimRedResult-method}
\alias{maximize_correlation,dimRedResult-method}
\alias{maximize_correlation}
\title{Maximize Correlation with the Axes}
\usage{
\S4method{maximize_correlation}{dimRedResult}(object,
  naxes = ncol(object@data@data), cor_method = "pearson")
}
\arguments{
\item{object}{A dimRedResult object}

\item{naxes}{the number of axes to optimize for.}

\item{cor_method}{which correlation method to use}
}
\description{
Rotates the data in such a way that the correlation with the first
\code{naxes} axes is maximized.
}
\details{
Methods that do not use eigenvector decomposition, like t-SNE often
do not align the data with axes according to the correlation of
variables with the data. \code{maximize_correlation} uses the
\code{\link[optimx]{optimx}} package to rotate the data in such a
way that the original variables have maximum correlation with the
embedding axes.
}
