#include <gsl/gsl_sf_log.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing "gsl_sf" from the beginning,
   of the name.  Thus gsl_sf_log_e goes to log_e and
   gsl_sf_complex_log_e goes to complex_log_e. */


void log_e(const double *x, const int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_log_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void log_abs_e(const double *x, const int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_log_abs_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void complex_log_e(const double *zr, const double *zi, const int *len, double *val_lnr, double *val_arg, double *err_lnr, double *err_arg, int *status)
{
	int i;
	gsl_sf_result lnr;
	gsl_sf_result arg;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_complex_log_e(zr[i], zi[i], &lnr, &arg) ;

		val_lnr[i] = lnr.val;
		val_arg[i] = arg.val;

		err_lnr[i] = lnr.err;
		err_arg[i] = arg.err;
	}
}

void log_1plusx_e(const double *x, const int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_log_1plusx_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void log_1plusx_mx_e(const double *x, const int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_log_1plusx_mx_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  
