% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-getIndexOmega.R
\name{getIndexOmega}
\alias{getIndexOmega}
\alias{.getIndexOmega}
\alias{.getIndexOmega.lvm}
\alias{.getIndexOmega.lvmfit}
\title{Identify the Endogenous Variables}
\usage{
.getIndexOmega(object, data, ...)

\method{.getIndexOmega}{lvm}(object, data, ...)

\method{.getIndexOmega}{lvmfit}(object, data, ...)
}
\arguments{
\item{object}{a \code{lvmfit} object.}

\item{data}{dataset.}

\item{...}{[internal] Only used by the generic method.}
}
\description{
Identify the endogenous variables, i.e., returns a vector with length the number of observations,
whose values are the index of the repetitions.
}
\examples{
\dontrun{
#### simulate data ####
set.seed(10)
dW <- sampleRepeated(10, format = "wide")
set.seed(10)
dL <- sampleRepeated(10, format = "long")
dL$time2 <- paste0("visit",dL$time)

#### lvm model ####
e.lvm <- estimate(lvm(c(Y1,Y2,Y3) ~ 1*eta + X1, eta ~ Z1), data = dW)
## lavaSearch2:::.getIndexOmega(e.lvm, data = dW)
}
}
\concept{extractor}
\keyword{internal}
