% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.mids}
\alias{as.mids}
\title{Converts an imputed dataset (long format) into a \code{mids} object}
\usage{
as.mids(long, where = NULL, .imp = ".imp", .id = ".id")
}
\arguments{
\item{long}{A multiply imputed data set in long format, for example
produced by a call to \code{complete(..., action = 'long', include = TRUE)},
or by other software.}

\item{where}{A data frame or matrix with logicals of the same dimensions
as \code{data} indicating where in the data the imputations should be
created. The default, \code{where = is.na(data)}, specifies that the
missing data should be imputed. The \code{where} argument may be used to
overimpute observed data, or to skip imputations for selected missing values.
Note: Imputation methods that generate imptutations outside of
\code{mice}, like \code{mice.impute.panImpute()} may depend on a complete
predictor space. In that case, a custom \code{where} matrix can not be
specified.}

\item{.imp}{An optional column number or column name in \code{long},
indicating the imputation index. The values are assumed to be consecutive
integers between 0 and \code{m}. Values \code{1} through \code{m}
correspond to the imputation index, value \code{0} indicates
the original data (with missings).
By default, the procedure will search for a variable named \code{".imp"}.}

\item{.id}{An optional column number or column name in \code{long},
indicating the subject identification. If not specified, then the
function searches for a variable named \code{".id"}. If this variable
is found, the values in the column will define the row names in
the \code{data} element of the resulting \code{mids} object.}
}
\value{
An object of class \code{mids}
}
\description{
This function converts imputed data stored in long format into
an object of class \code{mids}. The original incomplete dataset
needs to be available so that we know where the missing data are.
The function is useful to convert back operations applied to
the imputed data back in a \code{mids} object. It may also be
used to store multiply imputed data sets from other software
into the format used by \code{mice}.
}
\note{
The function expects the input data \code{long} to be sorted by
imputation number (variable \code{".imp"} by default), and in the
same sequence within each imputation block.
}
\examples{
# impute the nhanes dataset
imp <- mice(nhanes, print = FALSE)
# extract the data in long format
X <- complete(imp, action = "long", include = TRUE)
# create dataset with .imp variable as numeric
X2 <- X

# nhanes example without .id
test1 <- as.mids(X)
is.mids(test1)
identical(complete(test1, action = "long", include = TRUE), X)

# nhanes example without .id where .imp is numeric
test2 <- as.mids(X2)
is.mids(test2)
identical(complete(test2, action = "long", include = TRUE), X)

# nhanes example, where we explicitly specify .id as column 2
test3 <- as.mids(X, .id = ".id")
is.mids(test3)
identical(complete(test3, action = "long", include = TRUE), X)

# nhanes example with .id where .imp is numeric
test4 <- as.mids(X2, .id = 2)
is.mids(test4)
identical(complete(test4, action = "long", include = TRUE), X)

# example without an .id variable
# variable .id not preserved
X3 <- X[, -2]
test5 <- as.mids(X3)
is.mids(test5)
identical(complete(test5, action = "long", include = TRUE)[, -2], X[, -2])

# as() syntax has fewer options
test7 <- as(X, "mids")
test8 <- as(X2, "mids")
test9 <- as(X2[, -2], "mids")
rev <- ncol(X):1
test10 <- as(X[, rev], "mids")

# where argument copies also observed data into $imp element
where <- matrix(TRUE, nrow = nrow(nhanes), ncol = ncol(nhanes))
colnames(where) <- colnames(nhanes)
test11 <- as.mids(X, where = where)
identical(complete(test11, action = "long", include = TRUE), X)
}
\author{
Gerko Vink
}
\keyword{mids}
