% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc-prj.R
\name{nc_gm_to_prj}
\alias{nc_gm_to_prj}
\alias{nc_gm_to_prj.data.frame}
\alias{nc_gm_to_prj.list}
\title{Get projection from NetCDF-CF Grid Mapping}
\usage{
nc_gm_to_prj(x)

\method{nc_gm_to_prj}{data.frame}(x)

\method{nc_gm_to_prj}{list}(x)
}
\arguments{
\item{x}{list or data.frame of attributes of the grid mapping variable
as returned by ncdf or ncdf4's get attributes functions or ncmeta's nc_grid_mapping_atts.}
}
\value{
A proj4 string.
}
\description{
Takes NetCDF-CF grid mapping attributes and returns
a proj4 string.
}
\details{
The WGS84 datum is used as a default if one os not provided
in the grid mapping.

If only a semi_major axis is provided, a sperical earth is assumed.
}
\examples{

crs <- list(grid_mapping_name="latitude_longitude",
            longitude_of_prime_meridian = 0,
            semi_major_axis = 6378137,
            inverse_flattening = 298)
nc_gm_to_prj(crs)
}
\references{
\enumerate{
\item \url{https://en.wikibooks.org/wiki/PROJ.4}
\item \url{https://trac.osgeo.org/gdal/wiki/NetCDF_ProjectionTestingStatus}
\item \url{http://cfconventions.org/cf-conventions/cf-conventions.html#appendix-grid-mappings}
}
}
