% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_mcfadden.R
\name{r2_mcfadden}
\alias{r2_mcfadden}
\title{McFadden's R2}
\usage{
r2_mcfadden(model)
}
\arguments{
\item{model}{Generalized linear or multinomial logit (\code{mlogit}) model.}
}
\value{
For most models, a list with McFadden's R2 and adjusted McFadden's
  R2 value. For some models, only McFadden's R2 is available.
}
\description{
Calculates McFadden's pseudo R2.
}
\examples{
if (require("mlogit")) {
  data("Fishing", package = "mlogit")
  Fish <- mlogit.data(Fishing, varying = c(2:9), shape = "wide", choice = "mode")

  model <- mlogit(mode ~ price + catch, data = Fish)
  r2_mcfadden(model)
}
}
\references{
\itemize{
  \item McFadden, D. (1987). Regression-based specification tests for the multinomial logit model. Journal of econometrics, 34(1-2), 63-82.
  \item McFadden, D. (1973). Conditional logit analysis of qualitative choice behavior.
}
}
