% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeNamespace_roclet.R
\name{mergeNamespace_roclet}
\alias{mergeNamespace_roclet}
\title{A custom Roxygen roclet that adds Redland RDF functions to NAMESPACE file generated by Roxygen.}
\usage{
mergeNamespace_roclet(x, ...)
}
\arguments{
\item{x}{a roclet}

\item{...}{additional parameters}
}
\description{
The redland package uses the SWIG (Simplified Wrapper and Interface Generator) to
create the bindings between the Redland RDF C/C++ libraries and R. SWIG creates a NAMESPACE
file that contains the function names for the librdf wrapper that it creates, but as of
swig 3.0.2 this NAMESPACE file is incorrect and will also be overwritten by Roxygen when
'roxygenize()' or 'devtools:document()' is called, as the wrapper R code doesn't contain
Roxygen export annotations used by Roxygen to build the namespace file.
To allow for building a NAMESPACE file from all programs in the redland package, this roclet
determines the set of wrapper R functions and adds these to the Roxygen generated NAMESPACE file
that contains all names from the native R code in the redland package.
}
\details{
The following line must be present in the DESCRIPTION file for this roclet to be
called automatically when 'roxygen2::roxygenize()' or 'devtools::document()' is called:

Roxygen: list(roclets = c("collate", "rd", "namespace", "mergeNamespace_roclet"))

The 'namespace' roclet must always run before the 'mergeNamespace' roclet.
}
\examples{
\dontrun{
roxygen2::roxygenize()
devtools::document()
}
}
