% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr.R
\name{has_length}
\alias{has_length}
\title{How long is an object?}
\usage{
has_length(x, n = NULL)
}
\arguments{
\item{x}{A R object.}

\item{n}{A specific length to test \code{x} with. If \code{NULL},
\code{has_length()} returns \code{TRUE} if \code{x} has length greater than
zero, and \code{FALSE} otherwise.}
}
\description{
This is a function for the common task of testing the length of an
object. It checks the length of an object in a non-generic way:
\code{\link[base:length]{base::length()}} methods are ignored.
}
\examples{
has_length(list())
has_length(list(), 0)

has_length(letters)
has_length(letters, 20)
has_length(letters, 26)
}
