% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_search.R
\name{tweet_search_recent}
\alias{tweet_search_recent}
\title{Search recent tweets}
\usage{
tweet_search_recent(
  query,
  n = 100,
  expansions = NULL,
  fields = NULL,
  ...,
  token = NULL,
  parse = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{query}{One query for matching Tweets.}

\item{n}{Number of tweets to query.}

\item{expansions}{Set \code{NULL} to not use any expansion, set \code{NA} to get all
expansions, or provide a vector with the expansions you want (create it with
\code{\link[=set_expansions]{set_expansions()}}).}

\item{fields}{Set \code{NULL} to not use any field, get all allowed fields with \code{NA},
provide a list with the fields you want (create it with \code{\link[=set_fields]{set_fields()}}).}

\item{...}{Other arguments passed to the API.}

\item{token}{These endpoints only accept a bearer token (can be created via
\code{\link[=rtweet_app]{rtweet_app()}}). In most cases you
are better of changing the default for all calls via \code{\link[=auth_as]{auth_as()}}.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{verbose}{A logical value to provide more information about the
paginated queries (if any) and to store the data of each page.}
}
\description{
Look up tweets from the last seven days that match a search query.
}
\note{
OAuth2.0 requires tweet.read and users.read permissions.
}
\examples{
if (FALSE) {
  sr <- tweet_search_recent("#rtweet", sort_order = "relevancy", parse = FALSE)
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/tweets/search/api-reference/get-tweets-search-recent}
}
