% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{FindBridgeAnchor}
\alias{FindBridgeAnchor}
\title{Find bridge anchors between two unimodal datasets}
\usage{
FindBridgeAnchor(
  object.list,
  bridge.object,
  object.reduction,
  bridge.reduction,
  anchor.type = c("Transfer", "Integration"),
  reference = NULL,
  laplacian.reduction = "lap",
  laplacian.dims = 1:50,
  reduction = c("direct", "cca"),
  bridge.assay.name = "Bridge",
  reference.bridge.stored = FALSE,
  k.anchor = 20,
  k.score = 50,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object.list}{A list of Seurat objects}

\item{bridge.object}{A multi-omic bridge Seurat which is used as the basis to
represent unimodal datasets}

\item{object.reduction}{A list of dimensional reductions from object.list used
to be reconstructed by bridge.object}

\item{bridge.reduction}{A list of dimensional reductions from bridge.object used
to reconstruct object.reduction}

\item{anchor.type}{The type of anchors. Can
be one of:
\itemize{
  \item{Integration: Generate IntegrationAnchors for integration}
  \item{Transfer: Generate TransferAnchors for transfering data}
}}

\item{reference}{A vector specifying the object/s to be used as a reference
during integration or transfer data.}

\item{laplacian.reduction}{Name of bridge graph laplacian dimensional reduction}

\item{laplacian.dims}{Dimensions used for bridge graph laplacian dimensional reduction}

\item{reduction}{Dimensional reduction to perform when finding anchors. Can
be one of:
\itemize{
  \item{cca: Canonical correlation analysis}
  \item{direct: Use assay data as a dimensional reduction}
}}

\item{bridge.assay.name}{Assay name used for bridge object reconstruction value (default is 'Bridge')}

\item{reference.bridge.stored}{If refernece has stored the bridge dictionary representation}

\item{k.anchor}{How many neighbors (k) to use when picking anchors}

\item{k.score}{How many neighbors (k) to use when scoring anchors}

\item{verbose}{Print messages and progress}

\item{...}{Additional parameters passed to \code{FindIntegrationAnchors} or
\code{FindTransferAnchors}}
}
\value{
Returns an \code{\link{AnchorSet}} object that can be used as input to
\code{\link{IntegrateEmbeddings}}.or \code{\link{MapQuery}}
}
\description{
First, bridge object is used to reconstruct two single-modality profiles and
then project those cells into bridage graph laplacian space.
Next, find a set of anchors between two single-modality objects. These
anchors can later be used to integrate embeddings or transfer data from the reference to
query object using the \code{\link{MapQuery}} object.
}
\details{
\itemize{
 \item{ Bridge cells reconstruction
 }
  \item{ Find anchors between objects. It can be either IntegrationAnchors or TransferAnchor.
 }
}
}
