% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.FileMove}
\alias{.FileMove}
\title{Move Files and Directories}
\usage{
.FileMove(path, new_path, overwrite = FALSE, n = 1L)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{new_path}{New file path. If \code{new_path} is existing directory, the file
will be moved into that directory; otherwise it will be moved/renamed to
the full path.

Should either be the same length as \code{path}, or a single directory.}

\item{n}{The number of callers to go back.}
}
\value{
The new path (invisibly).
}
\description{
Move files and directories with \pkg{fs}; includes a handler for when
\code{path} is a directory on a different filesystem than \code{new_path}
by explicitly copying and deleting \code{path}
}
\note{
This function requires the
\href{https://cran.r-project.org/package=fs}{\pkg{fs}} package
to be installed
}
\seealso{
\code{\link[fs:file_move]{fs::file_move}()}
}
\keyword{internal}
