% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genbank2uid.R
\name{genbank2uid}
\alias{genbank2uid}
\title{Get NCBI taxonomy UID from GenBankID}
\usage{
genbank2uid(id, batch_size = 100, ...)
}
\arguments{
\item{id}{A GenBank accession alphanumeric string, or a gi numeric string.}

\item{batch_size}{The number of queries to submit at a time.}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}}
}
\value{
one or more NCBI taxonomic IDs
}
\description{
Get NCBI taxonomy UID from GenBankID
}
\details{
See \url{http://www.ncbi.nlm.nih.gov/Sitemap/sequenceIDs.html} for
help on why there are two identifiers, and the difference between them.

Note that if you pass in > 1 item, if one or more of your items is not
found, the entire batch will return \code{NA}'s. To get around this,
set \code{batch_size = 1} - so each is sent separtaely to NCBI.
However, this of course is much slower than the default, which is to send
up to 100 at a time.
}
\examples{
\dontrun{
# with accession numbers
genbank2uid(id = 'AJ748748')
genbank2uid(id = 'Y13155')
genbank2uid(id = 'X78312')
genbank2uid(id = 'KM495596')

# with gi numbers
genbank2uid(id = 62689767)
genbank2uid(id = 22775511)
genbank2uid(id = 156446673)

# pass in many accession or gi numbers
genbank2uid(c(62689767,156446673))
genbank2uid(c('X78312','KM495596'))
genbank2uid(list('X78312',156446673))

# curl options
library('httr')
genbank2uid(id = 156446673, config=verbose())
}
}
