% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestPattern.R
\name{BodyPattern}
\alias{BodyPattern}
\title{BodyPattern}
\description{
body matcher
}
\examples{
# make a request signature
bb <- RequestSignature$new(
  method = "get",
  uri = "https:/httpbin.org/get",
  options = list(
    body = list(foo = "bar", a = 5)
  )
)

# make body pattern object
z <- BodyPattern$new(pattern = list(foo = "bar"))
z$pattern
z$matches(bb$body)
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pattern}}{a list}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BodyPattern$new()}}
\item \href{#method-matches}{\code{BodyPattern$matches()}}
\item \href{#method-to_s}{\code{BodyPattern$to_s()}}
\item \href{#method-clone}{\code{BodyPattern$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{BodyPattern} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BodyPattern$new(pattern)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{(list) a body object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{BodyPattern} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-matches"></a>}}
\subsection{Method \code{matches()}}{
Match a list of headers against that stored
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BodyPattern$matches(body, content_type = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{(list) the body}

\item{\code{content_type}}{(character) content type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a boolean
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_s"></a>}}
\subsection{Method \code{to_s()}}{
Print pattern for easy human consumption
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BodyPattern$to_s()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BodyPattern$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
