// Code generated by go generate.
// Source file: keygen.go
// DO NOT EDIT!

package keystoretest

var KeyMap = map[string]*KeyDetails{
	"example.com": {
		Fingerprint: `4d5b338b00c2935b90e50c16d71af6b1683451d2`,
		ArmoredPublicKey: `-----BEGIN PGP PUBLIC KEY BLOCK-----

xsBNBFSv1kwBCADT63SDJiS3b44ogYTFrGctNuApVkyDTs/Nx4orjh52GLjaisgl
p36DKxvFID1r3EJtV4gxlK9VMvDteDHTzWRLfBo4mwbYq4LQn6IQBamnRRHra7PX
i/M5MSse1lTM/a+0uIYBQH90nGbi8tYSHUzlHsJARYSCmz35NNEyMp70X7ZhfB1J
Ha32voWRWHhOC4bkLst8ZF2kMSaxM2PEqfcdg0Os2l0sLCgiTNBBn8dEzlBCj4Qb
qvSnWdO9EHw0CSYYZZ8kp76aHd9orPdV4U2eQWQkuDphz4QUYvv3Jfxji31cdM5O
2L5NDJHHoenbbHLwcJqC2PALm+DLycesaRVzABEBAAHNNXNpZ25lciAoZXhhbXBs
ZS5jb20gU2lnbmluZyBLZXkpIDxzaWduZXJAZXhhbXBsZS5jb20+wsBiBBMBCAAW
BQJUr9ZMCRDXGvaxaDRR0gIbAwIZAQAAilcIANCq+FS9wlp+kIA5EMZfNL74IKdy
qbAeOhZVR1FfR45lGym7Oa+10192dyE0FRR6vrjJS0pNHoqpPUB18tiM39uEWOkx
iHhJDB7+jYDMGf6WT6tgg8HzeRpA4v4eML/vq8aZt3LZQFeIMziC8CYN+mOn56yT
1rnazqvdN5fWF3UrNQfJyfl8nifiN42EoPwXgzjaldNxWAuUirj9xh75T2PWQnwK
09qO7BVhpOF5qdB9oLAnDNE8eAyHbLEpkGf6cUrZS4Xo1/2pwpSKD6mwh9h8KAf9
ubHeNHA/0cFy1M2pMXX58d2MbxWKIhIDderI35t6ytjFEOnM3Iub8VJE+8POwE0E
VK/WTAEIAPDkclqaKGs7fvaqDVM6TeSCLBPJGQKBR/CFAwf0ZVWy/WnWLbbh7g2n
VE/4a49ZtZM0liaxqQ54TRBcPRJdlFjTX23JYe2NbcowF7sWV5pKQWo1wE8bgLPT
xV4jMdau9If9BOUZvEO8rtzsonOEBm+xiWIuPWOgOcI1r3aY4cpwGsRBy9aTERJb
KVop+50bNsrrxfeaj5pF9EJThRUF5XkwUKOBwZZmWltc4rRS1pg5oKuIqluW3pMZ
EViRd2eFmk0ETxY/+diu7nyJwJC6U2yPi9tCMjtMtCtXd4NNAEqqHVeYf0rMfTYl
AfwL1rkuXa7TGbrmTUseMz+LEAUiHB8AEQEAAcLAXwQYAQgAEwUCVK/WTAkQ1xr2
sWg0UdICGwwAALEqCACu43JJqXZaMpV5krVEFtMhVBXrhU01XPu3yKRtB6euBaeK
od5LC5d90I0iQn67q5Nf/YHajnY+MyW6nuhaNSsFLt1JkTl1SfFIPK8rE/basvz2
drFCqgOWJk1Uuwg9feD5sW4MAOoAUMbO4BSTcUF+N0VeJqXzg/vW6LhxZzm2Tiqa
yibx/iEWIzsFUnqZi5VR+O2lO6sd1yRqt38w5oDGquBYnA41VY47ACCG2JZdFTN6
QRVYn50iq5RwNoWpELVTGNaBdJHGSj/SqRMMu6VBp6Xd3zQy0HgZ0uSkVH9rpClN
zRXrKWVqCk2JjaaXM0FEVJpZQeT74hfe+NVFKJQf
=fohd
-----END PGP PUBLIC KEY BLOCK-----`,
		ArmoredPrivateKey: `-----BEGIN PGP PRIVATE KEY BLOCK-----
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=mdQJ
-----END PGP PRIVATE KEY BLOCK-----`,
	},
	"coreos.com": {
		Fingerprint: `78b3fd7a0089dd84abad6641cbf56f3df44ede02`,
		ArmoredPublicKey: `-----BEGIN PGP PUBLIC KEY BLOCK-----

xsBNBFSv1k4BCADFSK8QvecBxFQmA5+lXuCGjnwk53QeeVWKL865V5oCjfi2UR31
+3B4ITn+cBJF9svwQhsIuvja+m9I+ESoVNFopwrGo6+iAsioM6N7gzvxDmrbYZ/9
PR8Sl3VsWBwQushawjNQsNcreW6k/dMB0RrIRp8Dmn2G49gbelElJkG+oa9ieVRx
pQ6tccaQGrwszZEcks3rnaa163DiTlyiaaiEFYacMwecV8GraWgLt4J9/Xwi6u6O
L/ORKijIG4yzYs5oZqlf3FAXKpIkg5wNTgH63TZ2jK0MUjt02Af7GQ1vIe3wJ2v7
MCvJqq7A7PKwNvEYp6j/3ZR/dV4U1uOidV8PABEBAAHNM3NpZ25lciAoY29yZW9z
LmNvbSBTaWduaW5nIEtleSkgPHNpZ25lckBjb3Jlb3MuY29tPsLAYgQTAQgAFgUC
VK/WTgkQy/VvPfRO3gICGwMCGQEAABi0CAC9Z8kydxk2/rLaQ6GLQYiNc4TxQjFr
T9AnW86Lh0Vzr6obSw0k8eZIkmTBaeu/yVm1E1p0rjNO4QgrLVTew6Kq9+mf+r2v
rHDXTmwtSrjtiH/jIwdFom2NkYaDIq3R1cgpgpkkCSDkB2saBdJDVbRH54Lc28oC
lWkHXKN4KZaayvJ0DCp1g3ISTr+BWjKNgHrlFdoKVgMfetZjVnEqVBrTfqqFAIRf
yCDDPmSmDffG9ROPwe8d9rMpPU9SnpoWvzdpuNzBGjNQTgjy55fjjWOGOdL3Tm4G
3N3P2Xopdj927WpnFLycxoVz9wo3SCi+mSXm+xXjcKO+mZNPqxQv8NJNzsBNBFSv
1k4BCADkzCqgvxxawwFiKxeyBwn+4bZ5CoKXblLSHj/fCn2PF4Nln+4HwqUbpsWI
Gu3eDbID9gycxrMa/T0THNqyCxok3gu3Fb7277Xlx/3USbWgP6vlI4SLyZT5yUiK
uFR8OpmiSWdzT5mAxo21l0F08RmepQiXAdKe7mfW0NVUWMm7JMWS22DmRiZfe9sI
AavDVRlZrvnhgYu7cEW/zQqcP2tjKDFJttKTQiskzeKRkyDHPF/FuLtU3HyVfvYf
0+KERxdhBTriDkEqzpFV5U6UVFYM4Sp5Y0cnVBB30F2SV0+hjRcgpzCCgI9tfReq
B5yLvkLKpZNi2JCHPm+hhmdNQWMlABEBAAHCwF8EGAEIABMFAlSv1k4JEMv1bz30
Tt4CAhsMAAAekQgAbUy2Ab9HVwB0QIW06Vrc/JG91tI2dhQpViI0I6hWm3RK7Zqe
AiJQKPhhHbAXbNK3sgnfGjaCoJ6wxsTnheciYUVuh83o4Rf5pKhsu40W4Vz6q9oD
TQMQStVBfBiPUKX45aaB2pAQqoOHuA0++wHIc1q3RMNniJHHL2gaAIipG0Qb8hU+
dZJJxz3QLlL1Dk9zkbWPAuX6WyqcfwvQolfvnAUwp5s2FCdGsFtwlACDnzYD7TV4
jzDcRB4Zvnlqto+X76++XWM+fpVVWOZsIxkOv4TPbijQA5tXwZeiWj8U0XCxQuAw
HtRc9/fBNDsEYZ+8LT4iKnzFpl7OvkHuj7SbRA==
=6lcW
-----END PGP PUBLIC KEY BLOCK-----`,
		ArmoredPrivateKey: `-----BEGIN PGP PRIVATE KEY BLOCK-----
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=Aa3W
-----END PGP PRIVATE KEY BLOCK-----`,
	},
	"example.com/app": {
		Fingerprint: `847157ec2524660482f8940beeafad1ea7040030`,
		ArmoredPublicKey: `-----BEGIN PGP PUBLIC KEY BLOCK-----

xsBNBFSv1lABCADFuxHGsJlZj9YJYh9xDUp9dbg8+FKRRquDxiyiFLfAqF1b3ad8
efPJYNd+rQQ6opcx8RbucYPK2W76twva4a65NsynP/8+N2AHrcUDou1+U9slBOUV
cIm/HOEKUcqE2YHEk77GVm1CkiWrURjjTZko6qYe333auFxlrLiQzZyfAvvQvHjj
WYSHTUk8YjvA6G0drAc6pM81GbVpfJb+MSADCWNMuMOIlmn0mKGJoevOcfl9TZBX
Tl8jbrT2qZUfDU5rLQZhL+bkyb22No/Z9P0AFSUEBVUBDxKMltfk+D1VrjgVZlYO
H5zFEnJzGhmbIABBOL/zbSGRrtEz2X+BntkxABEBAAHNOXNpZ25lciAoZXhhbXBs
ZS5jb20vYXBwIFNpZ25pbmcgS2V5KSA8c2lnbmVyQGV4YW1wbGUuY29tPsLAYgQT
AQgAFgUCVK/WUAkQ7q+tHqcEADACGwMCGQEAALM2CAAMrRIhpzVkHPTbPditcGic
CjW82QoU0kMM3FQXfHYWY7bKeXCHQ2NnvCNz2/JugLGHygz93+NNUt1gHS3NJQgE
eObAoHiJR5EYNxpbU21CNj7IYVX0zHT6oc+OlrVgrd13TYuN5MZZJ1y69GRLSeGF
RVVFziN51HdaDJRUoBttFcTewWpGyZl6GFs18tNzlHtfuiSQ+sPlgcyNZUVRT5cs
BVuPvc97GUcKXFGUQ2bJJIyKN5Af88Wf4H+k4zilHwiewPWKnNLjf6dxj58lPkNY
qmC8JIMsAFINJq9U8SPqgMtMpJ861u5JRhdH0sfV2q/8M2jVlnKRh687YRA3pBQF
zsBNBFSv1lABCADAJIiw/4RV97OefWquK4oN3q2ObfuKW9gof7GwInYSNYuUcv8/
F0odWzKKWnmsoWTeqerz25ht9XXCFWRsuOnCFy0EBvqP3Gu/K6F3eD3jnusdsS7e
lOetrFuGOaWUIdPcIDyddofMeuW0rf+yps0U7b8MrAYFPgLix/k2I5erdjiowYG7
XqM+y+y2/uPfC0HoAdOVKkHmpK9TZ/kyNyX6lf4Yd5f3BA3aYEYTgIvZe7wrlh+F
7EMFeja7wh0FgYFDYqpEokz34C15L+WunSUTgmvH6rZHJHWtxSyg1F1ZZQQqBLDc
Kf9DStk5Wk8N3S6fDk9Qv9DjzYviMWsrQQeTABEBAAHCwF8EGAEIABMFAlSv1lAJ
EO6vrR6nBAAwAhsMAACTxAgAxAEBz7VdLmOEBn1CflTdkEqiCyvksVHOIGpw5gIB
bR6TQYU0Utsxx4hXoyuyekrvCro7vXfdD+f1USaqf1jeA4e/Hiucd+dhuqht0Mou
k3WaCZVt+8y5+Gc55Fn0uWApHLKVH9OCc/So/M9sp60DfJGaf2KTK8gXrDBUXFXt
hXU/UMCQnP9lU+867rVRx7N8g3mo/6pppE2/2il1TNJqrL5l3EC8pkphFQD/r5Ue
8qTP0SWlPfkIYeEoNEHvaDzbL5t19XbhDnTUUn2rfNt2SKVe3m7+1sTJtvSbMuIw
WPpUksGYZX38KHDEEkNuFUJ3/HLqf1n3zFQasWhxPPe4Ew==
=HBI/
-----END PGP PUBLIC KEY BLOCK-----`,
		ArmoredPrivateKey: `-----BEGIN PGP PRIVATE KEY BLOCK-----
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=iOdD
-----END PGP PRIVATE KEY BLOCK-----`,
	},
	"acme.com": {
		Fingerprint: `0580ac91290ca2bcdebe122cfc5f8bda55abd47d`,
		ArmoredPublicKey: `-----BEGIN PGP PUBLIC KEY BLOCK-----

xsBNBFSv1lEBCAC5/4MQMDdR57gRRbV5HwpFoER1T8NLS21DZ/HVmE9HkR1Ho9Jm
uuksO1bqGF0lzOcnw3kYt8DFmGaAHl3zqHK7n9XhHisiZa6a+U3ONE02b882RgEc
mPGnZRf1tHS15UqQ1WeTqSs47bzuiJ2I1hpOyT6j/WXz6sHDS80M64Mi8XhiOtEg
RikpNQdnOgD4AEV3xNEBLJ2ls9zHLTtPwdzgiyo3qvEzm2sDH2biZxZsyWoXNPu6
89GBLuvShG4mgZsGs9LJD/MTCecQHbUYwL4bczGJyOKf9xoe0TLKJvk7Af8UPwHw
GiviXDEpUjefNCAMpkJIiicAjPfStAdzGJ6fABEBAAHNL3NpZ25lciAoYWNtZS5j
b20gU2lnbmluZyBLZXkpIDxzaWduZXJAYWNtZS5jb20+wsBiBBMBCAAWBQJUr9ZR
CRD8X4vaVavUfQIbAwIZAQAAxB8IABX0EdjXiBtdCGvvSGbrSjoGld4u6wyBlQpp
nesEv0uJLzWFjmKLwLx7mSxo/WaThL+3EX5BDXNy2CZ/o9LrPH7eVwluCYluUZHl
3fKhbvmr5g8R+0kvYau50TGS4wdZo+1j0YAXC/NuWVgiOi/+IU0UrwC0ZkOUGjrG
oT7WxmC3JR46U1ySrd8e4gr3H+hDNby2j6u23vd/zZ+w+mfrduuG5BUZVdzKiCqH
HC0VDNrwypCPOkugFr99H158W5aX0r3axt8UZ1qQvzUe436WrQ4+KGJJk1DDsAT9
otzzPEF+EVEcdqhLssdLvtoifYunrmt3bp/7raVx/0GIBDg8iB3OwE0EVK/WUQEI
AN4M9lCqAZ6lSpS5aWg5ifAa6K9Z0YpsHlUJzRaB/XznGhRiNqca/revCYZoorEm
C+prvcInklcaV/MUaAYfFFKRPTybI0DTme+BDUrxiCIs98V0Au2mSM0eiW6nlwtc
pYlS+ftt54rsoAnymNVvCjQb/aURiLM4nveeor5xTNdOA3IAeKUTEeYDnE+cHDGz
leZhCr4ua/sLApYPssxCuqgb7BiOWWTb2iTFN0XEPwA40mYdb1VG6fn4omEUyltC
gE0RQUdvmRFxx2OrsUnPfkp449vbnGSnHTUHtyMpq3/TnMrnJn6i/ox5l3ECfUrP
9lIdhmQz4EmNVUO9XslbogcAEQEAAcLAXwQYAQgAEwUCVK/WUQkQ/F+L2lWr1H0C
GwwAANwDCAAzpKIU8y+mXv2L4o//KLRQDKTlrW2XIkDduwMEygt3oKZAowcE2mtK
j5ufQeVm5JfFLOT+GiBrkssQv+MjanEhppVGGsVwdCe3TPonwUSdinAFCsajUx+M
wjnwqPQGUr14hRgf9neXQBnXq+HQrH923xQWTGgzAShBgGxbmohxGwPmhBVndPA3
ZYyYvClLKphlvHF+6EW1CKHIAWz6uX+s5W8vzZdH8Aw14lHbrbtly5KS8HE4OYxm
z/QNM2f9StyWYxmdwgFFuR1Y+THcOqjZW0rptO/bjx/Mfse0iZzf67k6e+qZ6AxH
GXjGKDYhVyWMVq0jAdRwgX9sLZMX0kTN
=tPYg
-----END PGP PUBLIC KEY BLOCK-----`,
		ArmoredPrivateKey: `-----BEGIN PGP PRIVATE KEY BLOCK-----
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=lHJX
-----END PGP PRIVATE KEY BLOCK-----`,
	},
	"acme.com/services": {
		Fingerprint: `418d97e1f80fcc35c996249b2f13c45b30c346ea`,
		ArmoredPublicKey: `-----BEGIN PGP PUBLIC KEY BLOCK-----

xsBNBFSv1lIBCADGew/0KqvHkcpI24qUkFSNEfKip0V/M365mTfc+nXazdZBUAVI
bQpxb1ic1w9jeGQf08VCSdOtggJgiPcFAbLMWnYGg3mHyRh3eVvZcXdg3ErFBpwn
vpIqtkx26Uu6ppi3P+EzenPJTk+0ZCfV57M+w/1FHGc725I61UGNUHnM3iEzcyaY
F3WdoBXtgmJPQqN0CYMiHFbFx00H/uzeKJLUPw9AV6quOlL2pQswOVTERCgT03LW
EpwBulWZIrtOeOvSG4+EFiy+DPIcy/95Ux60Mxd8d0+9g6yLwxi1H0nELic52V8E
pXUAxHxW1d6gxpJH8j2MQtcOv/FjnPFXdJVtABEBAAHNOHNpZ25lciAoYWNtZS5j
b20vc2VydmljZXMgU2lnbmluZyBLZXkpIDxzaWduZXJAYWNtZS5jb20+wsBiBBMB
CAAWBQJUr9ZSCRAvE8RbMMNG6gIbAwIZAQAA0t4IADoNmRADOCx2Kt0W/a6G6pDM
cEQEMI+UJdskk658RFQ1FSUM99xITXrv6+Dsyl+a/tW7FVSWKBDbqkOVHRWUESgl
xGv67uXJULVp71Qa2YjcV8ORtg0zTN741bXKxspVsSik7pdpm1Mnorvnsb5ej66A
zojPC/XG+iftsYSOWU/5cfm/o6T7F6r029Q4ux37TyPtIadWxsQlzrhciGi7nsQJ
vueAPKVzLGPkxBScQRNz7Q08F35fZiVxFmQz8eEpREf9PnoWKm/FhzDI+QSyvLu/
UoeLjHVAXcWq0Tk1QNUK0ozawP5leYzMIXwtozZiFRe7GGL4tgSUE0W2sQo2n0PO
wE0EVK/WUgEIAMzMWvdQ5NEmo/eny3htaRqUd3lLgxtdi0phEGNHTqieb/dJSf7x
PHEO7WJ5kcnHxKOB8+VOGCqlehH3XQ+RGyczWuYKKNnf5OF0cf8rEWGgNY8V6TSh
9fASxEB0aZ+ebMXvjEwXThA+6ydlN5LoTpSvyuaUqc93XS/356S1jR6dt/rltgZk
eGaZkliGH/yhKCV2psrP89Fiw+4QUbCRvxqHATGR6Xj0Yk7xGmryh+TZU/1kQcU0
IxTPSs+JKXMl3Yurkd7a4YQ+5J2cPx3IbZr6whbcypOWdxk/4NrIFnQyJioBL3/T
OGPmDdBbZtFHUDiRfqowHOaPIFM1YQv2HIMAEQEAAcLAXwQYAQgAEwUCVK/WUgkQ
LxPEWzDDRuoCGwwAAKeWCACLI7soZ45WdGajOERg6/EP9rTeDBKaVfxsQ2tkXloN
E9MW1uDwQMvxO2wj4z885hAPXyx8iiZG4feZnjfSXteyLYPO4uu6KeJDhCF/8A/U
o3G6opRgoWWntRhxpCanEz57Yd3PF6lHDu4m6ktbKOIVLUduKETbE87Xu1yStO+I
KVVk6f5YuAqp2aU5hUU/3Pss9tJhi9cQaGHNyu1HZzinu/r14CIvgwTMXKcKEK7F
j/QCO7IiXnDYvwJ4y6BAzYLCZe2fErZWE71Y5x9ZbEej71K0WJO989k8coxZfgZR
V90cDur+F6xLufAAsmabtSlHoejinL02/KF8NHU9prLv
=r7Xb
-----END PGP PUBLIC KEY BLOCK-----`,
		ArmoredPrivateKey: `-----BEGIN PGP PRIVATE KEY BLOCK-----
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=lUpJ
-----END PGP PRIVATE KEY BLOCK-----`,
	},
	"acme.com/services/web/nginx": {
		Fingerprint: `b555d08c15547bd283b9605578ca11a4fa553a28`,
		ArmoredPublicKey: `-----BEGIN PGP PUBLIC KEY BLOCK-----

xsBNBFSv1lMBCACxTH05he1qRFPvOlwOSzL0QyhqD+9HFMZ5+4vLxTsTosskkELZ
ydj7Dk07Q3qm5i41Oh4ym/MJJZyFz+qDcpn7OD41gXk1egN9PdmXBMGC1RF/Yl8r
EixcXVM7vAIH/u74V1PGf4Xlg6cQuF23uyPSy5JGgBatdJewGR6YT3O1PG8Dliwt
6P5WULf7p4KTgDJT81Ba6sZESLMeefyHyz5ra8ST7cOTIjyP2ajZEk90tp20SJx8
QsESyUR+xaHaj4hgCj47PosZfzYRCn7p29p+N7opcC5fbwME2J8HWSk27eDth8ai
3YfSiha24SdFOIIkopk545agRLBm15umWHkxABEBAAHNQnNpZ25lciAoYWNtZS5j
b20vc2VydmljZXMvd2ViL25naW54IFNpZ25pbmcgS2V5KSA8c2lnbmVyQGFjbWUu
Y29tPsLAYgQTAQgAFgUCVK/WUwkQeMoRpPpVOigCGwMCGQEAACjICAClRKQa06Ph
29nZ8Gboioe9bsW04n9J8keOF70qDpqK7FjwiC4vZHAlkcneHKYViADmrZxoeUhu
7j5c+LQlpjT7POzs2K/2Q0J8x4JGYFO0XTSByR89oUEWpRlRJ2A4vw1xdK4Jx+7x
bM4As6GR1W8qflRHQYJpRruNuXzfkK4DpQRc2O+8pnNRSz1flFUAiCVVU98VRKDV
uFc7UXfF6ANgk5ea0Nsb6dB4wQpWKkcNO48G8PPUp4p19ZtfZeZAtEpCzT9nJ6Si
z27vHieBCNfnk6BBLjPsyxwTHxF82aNv0baAVamC67W84nlqNBuaW1x9X+lj7yUD
4KgNT5X5BXjyzsBNBFSv1lMBCAChVIijeIs15jjwRXLu4/kkql2IW7q+0rvZIqjM
XUE5vufYaPovTzUh0Qs2P0qGaeYMf/scor946p0+QwzrYsn8qOG27PElX1/QmHY3
M9Z0InmYPrJZM8puvwdqhi8kIJ1YA7bfAX7Xu8BcIQX7pIxU5xK/hU8IOdrPK1VN
55jvAf7OA8ls15IcjYjD5SBosVYCfGsO5RrZD4qMSRofZAeQ6di0It7dwogkl1qu
vmVDzJ20UX+QVP+2zqgjBMCTX15gYDPMjFYCcfLssZvoa4Xon6+nRvKhTWvjWvBb
hPOd+WMdXQLEjw+UUdeqbHqZ7kfMErN8Hs+OpwKqAupczor3ABEBAAHCwF8EGAEI
ABMFAlSv1lMJEHjKEaT6VTooAhsMAACzuggAr2UYQpWd6/jEWlfbe6SthvQYqZ0n
cjPGTPqHh43hMi3ie85XARzIViCtKKDlLH1sQfCGmyZDVLrnJ+LS5APIfmqoUKzV
ASwnCiRYpKE+WZJIaagbmpPVxDrclVjQU9Gg1JrNSEyzxnr8pnACTWwtr0SEKMPC
2QkI63KtsUQQeyMoATm8KwS/64P2lINXnL5vJc/tzsGfCuNCK9OBB8Rb7Cs777bn
boTNt/FrAQLvrVfDyhhGLbAR6wKdpH/z5Gz4QRcjMx4MKXmhAOYdO1IlHTdGULek
PX/eIufXDa/hYbzaqAQISD7iNb63YwjCdwxscLUqbpKKxaMbiaxFnzdL4g==
=ffiP
-----END PGP PUBLIC KEY BLOCK-----`,
		ArmoredPrivateKey: `-----BEGIN PGP PRIVATE KEY BLOCK-----
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=twVN
-----END PGP PRIVATE KEY BLOCK-----`,
	},
}
