//waveform.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2014
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "roard.h"

// declared 'extern'.
struct waveform_stream g_waveform_mixer, g_waveform_recbridge;

static int waveform_init_recbridge (void) {
 struct roar_stream        *  s;

 if ( (g_waveform_recbridge.stream = streams_new()) == -1 )
  return -1;

 client_stream_add(g_self_client, g_waveform_recbridge.stream);

 streams_get(g_waveform_recbridge.stream, &(g_waveform_recbridge.ss));

 s = ROAR_STREAM(g_waveform_recbridge.ss);

 memcpy(&(s->info), g_sa, sizeof(struct roar_audio_info));

 s->pos_rel_id    =  g_waveform_mixer.stream;

 if ( streams_set_dir(g_waveform_recbridge.stream, ROAR_DIR_BRIDGE, 1) == -1 ) {
  streams_delete(g_waveform_recbridge.stream);
  g_waveform_recbridge.stream = -1;
  g_waveform_recbridge.ss     = NULL;
  return -1;
 }

 streams_set_name(g_waveform_recbridge.stream, "Record Bridge");

 streams_set_flag(g_waveform_recbridge.stream, ROAR_FLAG_PRIMARY);
 streams_set_flag(g_waveform_recbridge.stream, ROAR_FLAG_SYNC);
 streams_set_flag(g_waveform_recbridge.stream, ROAR_FLAG_MUTE);

 return 0;
}

int waveform_init  (void) {
 struct roar_stream_server * ss;
 struct roar_stream        *  s;
 int                          i;
 char                      cmap[ROAR_MAX_CHANNELS];

 // setup mixer:
 if ( (g_waveform_mixer.stream = add_mixer(ROAR_SUBSYS_WAVEFORM, _MIXER_NAME("Waveform"), &ss)) == -1 )
  return -1;

 g_waveform_mixer.ss = ss;

 s = ROAR_STREAM(ss);

 memcpy(&(s->info), g_sa, sizeof(struct roar_audio_info));

 roardsp_chanlist_init(cmap,   s->info.channels, ROARDSP_CHANLIST_MAP_ROARAUDIO);
 streams_set_map(g_waveform_mixer.stream, cmap, s->info.channels);

 ss->state = ROAR_STREAMSTATE_OLD;


 // setup Record Bridge:
 if ( waveform_init_recbridge() == -1 ) {
  ROAR_WARN("waveform_init(void): Can not setup Record Bridge.");
  streams_delete(g_waveform_mixer.stream);
  g_waveform_mixer.stream = -1;
  g_waveform_mixer.ss     = NULL;
  return -1;
 }

 streams_set_mixer_stream(g_waveform_recbridge.stream, g_waveform_mixer.stream);

 // attach all waveform streams to the mixer.
 for (i = 0; i < ROAR_STREAMS_MAX; i++) {
  if ( g_streams[i] != NULL ) {
   if ( streams_get_subsys(i) == ROAR_SUBSYS_WAVEFORM ) {
    streams_set_mixer_stream(i, g_waveform_mixer.stream);
   }
  }
 }

 return 0;
}

int waveform_free  (void) {
 return 0;
}

int waveform_update_inputs (void) {
 struct roar_buffer * buf;
 void * bufdata;

 // read recorded data...:
 if ( streams_recsource_id != -1 ) {
  if ( streams_get_outputbuffer(streams_recsource_id, &bufdata, g_input_buffer_len) == -1 ) {
   ROAR_WARN("waveform_update_mixer(void): can not request output buffer for record stream %i.", streams_recsource_id);
  } else {
   if ( streams_fill_mixbuffer2(streams_recsource_id, g_sa) == -1 ) {
    ROAR_WARN("waveform_update_mixer(void): can not fill output buffer for record stream %i.", streams_recsource_id);
   } else {
    memcpy(g_input_buffer, bufdata, g_input_buffer_len);
   }
  }
 }

 if ( !(g_waveform_recbridge.ss->flags & (ROAR_FLAG_PAUSE|ROAR_FLAG_MUTE)) ) {
  if ( roar_buffer_new_no_ma(&buf, g_input_buffer_len, g_input_buffer) == -1 ) {
   ROAR_ERR("waveform_update_inputs(void): Can not create a new buffer object for Record Bridge. Bad.");
   return -1;
  }

  if ( stream_add_buffer(g_waveform_recbridge.stream, &buf) == -1 ) {
   ROAR_ERR("waveform_update_inputs(void): Can not attach a new buffer object to the Record Bridge. Bad.");
   roar_buffer_free(buf);
   return -1;
  }
 }

 return 0;
}

int waveform_update_mixer (void) {
 if ( streams_get_flag(g_waveform_mixer.stream, ROAR_FLAG_MUTE) == 1 ) {
  memset(g_output_buffer, 0, (g_sa->bits*ROAR_OUTPUT_BUFFER_SAMPLES*g_sa->channels)/8);
  return 0;
 }

 if ( need_vol_change(ROAR_STREAM(g_waveform_mixer.ss)->info.channels, &(g_waveform_mixer.ss->mixer)) ) {
  roar_amp_pcm(g_output_buffer, g_sa->bits, g_output_buffer,
               ROAR_OUTPUT_BUFFER_SAMPLES*g_sa->channels, g_sa->channels,
               &(g_waveform_mixer.ss->mixer));
 }

 streams_ltm_calc(g_waveform_mixer.stream, &(ROAR_STREAM(g_waveform_mixer.ss)->info), g_output_buffer, (g_sa->bits*ROAR_OUTPUT_BUFFER_SAMPLES*g_sa->channels)/8);

 return 0;
}

//ll
