The `Copy` trait was implemented on a type which is neither a struct nor an
enum.

Erroneous code example:

```compile_fail,E0206
#[derive(Copy, Clone)]
struct Bar;

impl Copy for &'static mut Bar { } // error!
```

You can only implement `Copy` for a struct or an enum.
The previous example will fail because `&'static mut Bar`
is not a struct or enum.
