/*
 * Decompiled with CFR 0.152.
 */
package glguerin.authkit;

import glguerin.authkit.Privilege;
import glguerin.authkit.UnauthorizedException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Authorization {
    public static final int HAS_PROCESS_COUPLED_STREAMS = 1;
    public static final int HAS_PROCESS_INPUTSTREAM = 2;
    public static final int HAS_PROCESS_OUTPUTSTREAM = 4;
    public static final int HAS_PROCESS_ERRORSTREAM = 8;
    public static final int HAS_PROCESS_EXITVALUE = 16;
    public static final int HAS_PROCESS_WAITFOR = 32;
    public static final int HAS_PROCESS_DESTROY = 64;
    public static final int HAS_PROCESS_ELEVATED = 128;
    public static final int HAS_SYNTHETIC_PREAUTH = 256;
    public static final int HAS_SESSION_MULTIPROCESS = 512;
    public static final int WHEN_EARLIEST = 0;
    public static final int WHEN_LATEST = 1;
    protected Hashtable pastGranted = new Hashtable();

    protected Authorization() {
    }

    protected void finalize() throws Throwable {
        try {
            this.detach(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public abstract int getCapabilities();

    public boolean isCapable(int n) {
        return (this.getCapabilities() & n) == n;
    }

    public abstract void authorize(Privilege var1, boolean var2);

    public abstract void preauthorize(Privilege var1);

    public abstract boolean isAvailable(Privilege var1);

    public abstract void attach(byte[] var1);

    public abstract void attachPrivileged();

    public abstract void detach(boolean var1);

    public void release() {
        this.detach(false);
    }

    public abstract Enumeration getPastGrantedPrivileges();

    public abstract Date getPastGrantedDate(Privilege var1, int var2);

    protected Enumeration keysGranted() {
        return this.pastGranted.keys();
    }

    protected Date whenGranted(Privilege privilege, int n) {
        long[] lArray;
        if (n >= 0 && n <= 1 && (lArray = (long[])this.pastGranted.get(privilege)) != null) {
            return new Date(lArray[n]);
        }
        return null;
    }

    protected void addGranted(Privilege privilege) {
        long l = System.currentTimeMillis();
        Hashtable hashtable = this.pastGranted;
        synchronized (hashtable) {
            long[] lArray = (long[])this.pastGranted.get(privilege);
            if (lArray == null) {
                lArray = new long[2];
                lArray[0] = l;
                this.pastGranted.put(privilege, lArray);
            }
            lArray[1] = l;
        }
    }

    protected void clearGranted() {
        this.pastGranted.clear();
    }

    public abstract Privilege makeExecPrivilege(String var1);

    public abstract Process execPrivileged(String[] var1);

    public abstract int getSecretLength();

    public abstract byte[] getSecretIdentifier();

    public String getPublicIdentifier() {
        String string = "MD5";
        return this.formFingerprint(string, this.makeFingerprint(string));
    }

    /*
     * Unable to fully structure code
     */
    public byte[] makeFingerprint(String var1_1) {
        block7: {
            block8: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                }
                catch (NoSuchAlgorithmException var3_3) {
                    throw new UnauthorizedException("Missing MessageDigest imp: " + var1_1);
                }
                var3_4 = null;
                var4_5 = null;
                try {
                    var3_4 = this.getSecretIdentifier();
                    if (var3_4.length > 0) {
                        var2_2.reset();
                        var2_2.update(var3_4);
                        var5_6 = var3_4.length;
                        var2_2.update((byte)(var5_6 >> 24));
                        var2_2.update((byte)(var5_6 >> 16));
                        var2_2.update((byte)(var5_6 >> 8));
                        var2_2.update((byte)var5_6);
                        var4_5 = var2_2.digest();
                    }
                    var7_7 = null;
                    if (var3_4 == null) break block7;
                    var8_9 = 0;
                    ** while (var8_9 < var3_4.length)
                }
                catch (Throwable var6_11) {
                    var7_8 = null;
                    if (var3_4 == null) break block8;
                    var8_10 = 0;
                    ** while (var8_10 < var3_4.length)
                }
lbl-1000:
                // 1 sources

                {
                    var3_4[var8_9] = 0;
                    ++var8_9;
                    continue;
                }
lbl27:
                // 1 sources

                var3_4 = null;
                {
                    break block7;
                }
lbl-1000:
                // 1 sources

                {
                    var3_4[var8_10] = 0;
                    ++var8_10;
                    continue;
                }
lbl38:
                // 1 sources

                var3_4 = null;
            }
            var2_2.reset();
            throw var6_11;
        }
        var2_2.reset();
        return var4_5;
    }

    protected String formFingerprint(String string, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        String string2 = "0123456789ABCDEF";
        StringBuffer stringBuffer = new StringBuffer(string).append(':');
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            stringBuffer.append(string2.charAt(by >> 4 & 0xF)).append(string2.charAt(by & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }
}

